//
//  MCPSQLExpression.h
//  MCPersistence
//
//  Created by aj on Sat Dec 22 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@class MCPEntity;
@class MCPRelationship;
@class BDQualifier;
@class MCPTableAliases;

@interface MCPSQLExpression : NSObject {

	NSString					*_select;
	NSString					*_delete;
	NSString					*_update;
	NSString					*_insert;
	NSString					*_from;
	id							_where;  // NSData or NSString
 	NSString					*_order;
	
	NSData						*_fullStatement;
	
	
	MCPEntity					*_currentEntity;
	
	
	MCPTableAliases				*_entityAlias; // used for joins ...
	BOOL						_useAliases; // if setCurrentEntity, useAlias = NO, otherwise YES

}

- (void)reset;

- (void)setCurrentEntity:(MCPEntity *)ent;
- (MCPEntity *)currentEntity;


- (MCPTableAliases *)entityAliases;
- (void)setEntityAliases:(MCPTableAliases *)dict;
- (void)addEntity:(MCPEntity *)ent;
- (NSString *)aliasForEntity:(MCPEntity *)ent;
- (void)buildFromStatementUsingAliases;


// if this is set, this object will not build a statement, it will instead, return this when the 'statement' selector is called. You clear this by calling 'reset'.
- (void)setFullStatement:(NSData *)value;

- (void)setSelectStatement:(NSString *)value;
- (NSString *)selectStatement;

- (void)setDeleteStatement:(NSString *)value;
- (NSString *)deleteStatement;

- (void)setUpdateStatement:(NSString *)value;
- (NSString *)updateStatement;

- (void)setInsertStatement:(NSString *)value;
- (NSString *)insertStatement;


- (void)setFromStatement:(NSString *)value;
- (NSString *)fromStatement;

- (void)setWhereStatement:(NSString *)value;
- (NSString *)whereStatement;

- (void)setOrderStatement:(NSString *)value;
- (NSString *)orderStatement;

// Builds a t0.movieID, t1.something, t0.somethingElse or movieID, something, somethingElse depending whether we are using aliases or not. Does not set the current entity, but uses the entity to get its attributes (if none are passed) and to determine the table alias. Does not set the string anywhere -- you must do so -- returns an autoreleased string
- (NSString *)buildAttributeStatement:(NSArray *)attrs forEntity:(MCPEntity *)ent;

- (void)buildSelectAndFromStatementForAttributes:(NSArray *)attrs forEntity:(MCPEntity *)ent;
- (void)buildSelectAndFromStatementForAttributes:(NSArray *)attrs forEntity:(MCPEntity *)ent forceAlias:(BOOL)flag;


// Does not use aliases for 2 table joins (i.e. where MOVIE_ID = 215 AND SOMETHING = 345)
- (NSString *)makeSimpleJoinClauseForJoins:(NSArray *)joins 
	sourceRow:(NSDictionary *)raw joinSemantic:(int)js relationship:(MCPRelationship *)relation;

// uses aliases for multi table joins (i.e. where t1.MOVIE_ID = 215 AND t0.SOMETHING = 315)
- (NSString *)makeJoinClauseForJoins:(NSArray *)joins 
	sourceRow:(NSDictionary *)raw joinSemantic:(int)js relationship:(MCPRelationship *)relation;


- (id)statement;


// Added by mclark on Nov 12/2002
// New qualifer aware methods

- (void)buildSelectForEntity: (MCPEntity *)entity withQualifier: (BDQualifier *)qualifier;
- (void)_generateWhereForEntity: (MCPEntity *)entity withQualifier: (BDQualifier *)qualifier;



@end
